<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dir="http://apache.org/cocoon/directory/2.0">
      <xsl:param name="cssfile" />
	<xsl:param name="localURI" />
	<xsl:param name="detail" select="'none'"/>	
   	
	
  	<!-- structure principale --> 
   
	<!-- Elements lies a la navigation -->
	<xsl:template match="injacNav">
		<xsl:apply-templates />
	</xsl:template>
	
	<xsl:template match="injacNavPan">
      	<div id="iNavPan">
		<ul type="disc" id="currentFolder">
         		<xsl:apply-templates />
		</ul>
	</div>
   	</xsl:template>
	
	<!-- Template recursif pour decomposer en liens le chemin courant-->
	<xsl:template name="create-linked-path">
  		<xsl:param name="currentloc"/>
		<xsl:param name="fullpath" select="$currentloc"/>
			<xsl:choose>
			<xsl:when test="contains($currentloc, '/')">
				<xsl:call-template name="create-linked-path">
      					<xsl:with-param name="currentloc">
						<xsl:call-template name="remove-last-rep">
							<xsl:with-param name="breloc" select="$currentloc" />
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="fullpath" select="$fullpath"/>
				</xsl:call-template>
				<xsl:choose>
				<xsl:when test="$fullpath = $currentloc">
					<xsl:call-template name="last-rep">
						<xsl:with-param name="last-rep-uri" select="$currentloc" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
				<a href="{./upnode}?path={$currentloc}&amp;cssfile={$cssfile}">
					<xsl:call-template name="last-rep">
						<xsl:with-param name="last-rep-uri" select="$currentloc" />
					</xsl:call-template>
				</a>
				</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<a href="{./upnode}?path={$currentloc}&amp;cssfile={$cssfile}"><xsl:value-of select="$currentloc" /></a>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- sous-template recursif otant le dernier rep du path -->
	<xsl:template name="remove-last-rep" >
		<xsl:param name="breloc" />
		<xsl:param name="last-rep-uri" select="$breloc" />
		<xsl:choose>
			<xsl:when test="contains($last-rep-uri, '/')">
			<xsl:call-template name="remove-last-rep">
      				<xsl:with-param name="last-rep-uri" select="substring-after($last-rep-uri, '/')"/>
				<xsl:with-param name="breloc" select="$breloc"/>
	    		</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text/><xsl:value-of select="substring-before($breloc, concat('/', $last-rep-uri))" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>		
	
		
	<!-- sous-template recursif simulant la fonction lastOf() -->
	<xsl:template name="last-rep" >
		<xsl:param name="last-rep-uri"/>
		<xsl:choose>
			<xsl:when test="contains($last-rep-uri, '/')">
			<xsl:call-template name="last-rep">
      				<xsl:with-param name="last-rep-uri" select="substring-after($last-rep-uri, '/')"/>
	    			</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				/<xsl:value-of select="$last-rep-uri" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>		

	<xsl:template match="injacNavBar">
	<xsl:param name="currentloc" select="currentloc"/>
      	<div id="iNavBar">
		<div id="iCurrentLoc">
			<a href="{./upnode}?cssfile={$cssfile}"><xsl:value-of select="./upnode"/></a>
			<xsl:call-template name="create-linked-path">
				<xsl:with-param name="currentloc" select="currentloc"/>
	    		</xsl:call-template>
		</div>
		<div id="iBackUri"><a href="{./upnode}?cssfile={$cssfile}">Accueil</a></div>
      	</div>
   	</xsl:template>
	
	<!--xsl:template match="injacNavBar">
      	<div id="iNavBar">
		<div id="iCurrentLoc"><a href="{./upnode}?cssfile={$cssfile}"><xsl:value-of select="upnode"/></a><xsl:value-of select="currentloc"/></div>
		<div id="iBackUri"><a href="{./upnode}?cssfile={$cssfile}">Retour</a></div>
      	</div>
   	</xsl:template-->


	<!-- Elements de repertoire -->
	
	<xsl:template match="current">   	  
	<div id="current" ><xsl:value-of select="name"/></div>
   	</xsl:template>
   
   	<xsl:template match="directories">
	<div id="iDirectories"><xsl:apply-templates /></div>

   	</xsl:template>
	
   	<xsl:template match="files">
	<div id="iFiles"><xsl:apply-templates /></div>
   	</xsl:template>

 
 
   	<xsl:template match="directory">
       	<li class="directory">		
		<a href="{$localURI}?path={../@parent}{name}&amp;cssfile={$cssfile}">
			<xsl:value-of select="name" />
		</a>
		<xsl:choose>
			<xsl:when test="$detail='none'" />
			<xsl:when test="$detail='medium'">
				<ul type="circle">
				<li id="fileDate">creation : <xsl:value-of select="date" /></li>
				<!--li id="fileDate">modification : <xsl:value-of select="lastModified" /></li-->
				</ul>
      		</xsl:when>
			<xsl:when test="$detail='full'">
				<ul type="circle">
				<li id="fileDate">creation : <xsl:value-of select="date" /></li>
				<li class="fileSize">taille : <xsl:value-of select="size" /> octets</li>
				<li class="uri">URI : <xsl:value-of select="uri" /> octets</li>
				</ul>
      		</xsl:when>
		</xsl:choose>
		</li>
		
   	</xsl:template>

   	<xsl:template match="file">
      	<li class="file">
	<!-- Test pour eliminer le slash-->
	<xsl:choose>
		<xsl:when test="string-length(../@parent) != 1">
			<a href="{$localURI}?file={name}&amp;path={../@parent}&amp;cssfile={$cssfile}">
				<xsl:value-of select="name" />
			</a>
		</xsl:when>
		<xsl:otherwise>
			<a href="{$localURI}?{name}&amp;path=&amp;cssfile={$cssfile}">
				<xsl:value-of select="name" />
			</a>
		</xsl:otherwise>
	</xsl:choose>

       	<xsl:choose>
			<xsl:when test="$detail='none'" />
			<xsl:when test="$detail='medium'">
				<ul type="circle">
					<li class="fileDate">creation : <xsl:value-of select="date" /></li>
					<li class="fileSize">taille : <xsl:value-of select="size" /> octets</li>
				</ul>	
			</xsl:when>
			<xsl:when test="$detail='full'">
				<ul type="circle">
					<li class="fileDate">creation : <xsl:value-of select="date" /></li>
					<li class="fileDate">modification : <xsl:value-of select="lastModified" /></li>
					<li class="fileSize">taille : <xsl:value-of select="size" /> octets</li>
					<li class="uri">URI : <xsl:value-of select="uri" /> octets</li>
				</ul>	
			</xsl:when>
		</xsl:choose>
      	</li>
   	</xsl:template>
   
    
</xsl:stylesheet>

